/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.paginas.ventas;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.compras.FormaPago;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.ComprobanteVenta;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.PaginaFormasDePago;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.PaginaOperacion;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class PaginaFormasDeCobro
extends PaginaOperacion<ComprobanteVenta> {
    private ComprobanteVenta modeloDatos;

    public PaginaFormasDeCobro(Periodo periodo) {
        super(PaginaFormasDePago.class.getName(), "Anexo Transaccional", "Especifique la(s) forma(s) de cobro utlilizadas", periodo);
        this.setDescription("Especifique la(s) forma(s) de cobro utlilizadas");
        this.setTitle("Informaci\u00f3n del pago de la transacci\u00f3n");
        this.setLabelColumna("Formas de cobro");
    }

    public PaginaFormasDeCobro(boolean esNotaCredito, Periodo periodo) {
        this(periodo);
        this.esNotaCredito = esNotaCredito;
    }

    public void setModeloDatos(ComprobanteVenta modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.initDataBindings();
    }

    @Override
    protected void btnAgregarClicked() {
        this.btnEliminar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaFormasDeCobro.this.formaAgregar != null) {
                    if (!PaginaFormasDeCobro.this.modeloDatos.getFormasCobro().contains(PaginaFormasDeCobro.this.formaAgregar)) {
                        PaginaFormasDeCobro.this.modeloDatos.agregarFormasCobro(PaginaFormasDeCobro.this.formaAgregar);
                        PaginaFormasDeCobro.this.setPageComplete(true);
                        PaginaFormasDeCobro.this.tvFormasDePago.refresh();
                    } else {
                        PaginaFormasDeCobro.this.mostrarError("La forma de pago ya fue registrada");
                    }
                }
            }
        });
    }

    @Override
    protected void btnEliminarClicked() {
        this.btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaFormasDeCobro.this.formaSeleccionada != null) {
                    PaginaFormasDeCobro.this.modeloDatos.eliminarFormasCobro(PaginaFormasDeCobro.this.formaSeleccionada);
                    if (PaginaFormasDeCobro.this.modeloDatos.getFormasCobro().isEmpty()) {
                        PaginaFormasDeCobro.this.setPageComplete(false);
                        PaginaFormasDeCobro.this.tvFormasDePago.refresh();
                    }
                } else {
                    PaginaFormasDeCobro.this.mostrarError("No ha seleccionado una forma de Pago");
                }
            }
        });
    }

    public boolean isPageComplete() {
        if (this.esNotaCredito && !this.modeloDatos.getFormasCobro().isEmpty()) {
            return false;
        }
        if (this.esNotaCredito && this.modeloDatos.getFormasCobro().isEmpty()) {
            return true;
        }
        return !this.esNotaCredito && !this.modeloDatos.getFormasCobro().isEmpty();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvForma.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvForma.setContentProvider((IContentProvider)listContentProvider);
        IObservableList modeloValoresFormasPagoObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"formasPago");
        this.cvForma.setInput((Object)modeloValoresFormasPagoObserveList);
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap observeMap_1 = BeansObservables.observeMap((IObservableSet)listContentProvider_1.getKnownElements(), FormaPago.class, (String)"descripcionTipoFormaPago");
        this.tvFormasDePago.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_1));
        this.tvFormasDePago.setContentProvider((IContentProvider)listContentProvider_1);
        IObservableList modeloDatosFormasCobroObserveList = BeansObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloDatos, (String)"formasCobro");
        this.tvFormasDePago.setInput((Object)modeloDatosFormasCobroObserveList);
        return bindingContext;
    }
}

